#!perl
#
# Tests for PREPROCESSOR features
# These tests first appeared in version 1.25.

use strict;
use warnings;
use Text::Template::Preprocess;
use lib ("./t/testlib");
use Test::More tests => 16;
use File::Temp 0.14;

die "This is the test program for Text::Template::Preprocess version 1.45.
You are using version $Text::Template::Preprocess::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::Preprocess::VERSION == 1.45;

my $py = sub { tr/x/y/ };
my $pz = sub { tr/x/z/ };

my $t = 'xxx The value of $x is { sprintf("%3d", $x) }';
my $outx = 'xxx The value of $x is 119';
my $outy = 'yyy The value of $y is  23';
my $outz = 'zzz The value of $z is   5';

my $TF = new File::Temp();
my $tempfile = $TF->filename;

open $TF, ">$tempfile"
  or die "Could not open test file for writing: $!; aborting";
print $TF $t;
close $TF or die "Could not close test file: $!";

# 1st pass (8 tests):  Pass an argument to sub preprocessor().
preprocessor_test( 'do_py', [ $outx, $outy, $outz, $outz ] );

# 2nd pass (8 tests):  Do not pass an argument to sub preprocessor().
preprocessor_test( undef,   [ $outx, $outx, $outz, $outz ] );

sub preprocessor_test {
  my $instruction = shift;
  my $resultref = shift;
  my @result = @{$resultref};
  for my $trial ('string', 'filehandle') {
    for my $test (0 .. 3) {
      my $tmpl;
      if ($trial eq 'string') {
        $tmpl = new Text::Template::Preprocess
                   (TYPE => 'STRING', SOURCE => $t) or die;
      } else {
        open $TF, "< $tempfile"
          or die "Could not open test file for reading: $!; aborting";
        $tmpl = new Text::Template::Preprocess
                   (TYPE => 'FILEHANDLE', SOURCE => $TF) or die;
        close $TF or die "Could not close test file: $!";
      }
      if (($test & 1) == 1) {
        if (defined $instruction) {
          $tmpl->preprocessor($py);
        } else {
          $tmpl->preprocessor();
        }
      }
      my @args = ((($test & 2) == 2) ? (PREPROCESSOR => $pz) : ());
      my $o = $tmpl->fill_in(@args,
                             HASH => {x => 119, 'y' => 23, z => 5});
      is ($o, $result[$test], "$result[$test]\tfrom:  $trial");
    }
  }
}

