#!perl
#
# test apparatus for Text::Template module
# still incomplete.

use strict;
use warnings;
# use Test::More tests => 6;
use Text::Template 'fill_in_file', 'fill_in_string';
use lib ("./t/testlib");
use Test::More tests => 5;
use File::Temp 0.14;

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;

$Q::n = $Q::n = 119;

# (1) Test fill_in_string
my $out = fill_in_string('The value of $n is {$n}.', PACKAGE => 'Q' );
is ($out, 'The value of $n is 119.', "Test fill_in_string");

{  # define block within which filehandle $TF will be lexically scoped

# (2) Test fill_in_file
  my $TF = new File::Temp();
  my $tempfile = $TF->filename;

  open $TF, ">$tempfile"
    or die "Could not open test file for writing: $!; aborting";
  print $TF 'The value of $n is {$n}.', "\n";
  close $TF or die "Could not close test file: $!";
  $R::n = $R::n = 8128;

  $out = fill_in_file($tempfile, PACKAGE => 'R');
  is ($out, "The value of \$n is 8128.\n", "Test fill_in_file");

# (3) Jonathan Roy reported this bug:
  open $TF, ">$tempfile"
    or die "Could not open test file for writing: $!; aborting";
  print $TF "With a message here? [% \$var %]\n";
  close $TF or die "Could not close test file: $!; aborting";
  $out = fill_in_file($tempfile, DELIMITERS => ['[%', '%]'],
  		    HASH => { "var" => \"It is good!" });
  is ($out, "With a message here? It is good!\n",
          "Jonathan Roy reported this bug");

}  # end block defining scope of lexical filehandle

## fill_this_in() deprecated and deleted
## # (4) It probably occurs in fill_this_in also:
## $out =
##   Text::Template->fill_this_in("With a message here? [% \$var %]\n",
##                       DELIMITERS => ['[%', '%]'],
##                       HASH => { "var" => \"It is good!" });
##   is ($out, "With a message here? It is good!\n",
##           "It probably occurs in fill_this_in also");

# (5) This test failed in 1.25.  It was supplied by Donald L. Greer Jr.
# Note that it is different from (1) in that there is no explicit
# package=> argument.
use vars qw($string $foo $r);
$string='Hello {$foo}';
$foo="Don";
$r = fill_in_string($string);
is ($r, 'Hello Don',
"This test failed in 1.25.  It was supplied by Donald L. Greer Jr.
Note that it is different from (1) in that there's no explicit
package=> argument.");

# (6) This test failed in 1.25.  It is a variation on (5)
package Q2;
use Text::Template 'fill_in_string';
use vars qw($string $foo $r);
$string='Hello {$foo}';
$foo="Don";
$r = fill_in_string($string);

package main;

is ($r, 'Hello Don',
        "This test failed in 1.25.  It is a variation on (5)");

exit;

