#!perl
#
# test apparatus for Text::Template module
# still incomplete.

use Text::Template;
use lib ("./t/testlib");
use Test::More tests => 12;

die "This is the test program for Text::Template version 1.45.
You are using version $Text::Template::VERSION instead.
That does not make sense.\n
Aborting"
  unless $Text::Template::VERSION == 1.45;



$template = 'We will put value of $v (which is "good") here -> {$v}';

$v = 'oops (main)';
$Q::v = 'oops (Q)';

$vars = { 'v' => \'good' };

# (1) Build template from string
$template = new Text::Template ('type' => 'STRING', 'source' => $template);
ok($template, "Build template from string");

# (2) Fill in template in anonymous package
$result2 = 'We will put value of $v (which is "good") here -> good';
$text = $template->fill_in(HASH => $vars);
is ($text, $result2, "Fill in template in anonymous package");

# (3) Did we clobber the main variable?
is ($v, 'oops (main)', "Did we clobber the main variable?");

# (4) Fill in same template again
$result4 = 'We will put value of $v (which is "good") here -> good';
$text = $template->fill_in(HASH => $vars);
is ($text, $result4, "Fill in same template again");

# (5) Now with a package
$result5 = 'We will put value of $v (which is "good") here -> good';
$text = $template->fill_in(HASH => $vars, PACKAGE => 'Q');
is ($text, $result5, "Now with a package");

# (6) We expect to have clobbered the Q variable.
is ($Q::v, 'good', "We expect to have clobbered the Q variable");

# (7) Now let us try it without a package
$result7 = 'We will put value of $v (which is "good") here -> good';
$text = $template->fill_in(HASH => $vars);
is ($text, $result7, "Now let's try it without a package");

# (8-11) Now what does it do when we pass a hash with undefined values?
# Roy says it does something bad. (Added for 1.20.)
my $WARNINGS = 0;
{
  local $SIG{__WARN__} = sub {$WARNINGS++};
  local $^W = 1;       # Make sure this is on for this test
  $template8 = 'We will put value of $v (which is "good") here -> {defined $v ? "bad" : "good"}';
  $result8 = 'We will put value of $v (which is "good") here -> good';
  my $template =
    new Text::Template ('type' => 'STRING', 'source' => $template8);
  my $text = $template->fill_in(HASH => {'v' => undef});
  # (8) Did we generate a warning?
  cmp_ok ($WARNINGS, '==', 0, "Did we generate a warning?");

  # (9) Was the output correct?
  is ($text, $result8, "Was the output correct?");

  # (10-11) Let us try that again, with a twist this time
  $WARNINGS = 0;
  $text = $template->fill_in(HASH => [{'v' => 17}, {'v' => undef}]);
  # (10) Did we generate a warning?
  cmp_ok ($WARNINGS, '==', 0, "Did we generate a warning?");

  # (11) Was the output correct?
  SKIP: {
      skip "Not supported before 5.005", 1 if $] < 5.005;
      is ($text, $result8, "Was the output correct?");
  }
}


# (12) Now we will test the multiple-hash option  (Added for 1.20.)
$text = Text::Template::fill_in_string(q{$v: {$v}.  @v: [{"@v"}].},
				       HASH => [{'v' => 17},
						{'v' => ['a', 'b', 'c']},
						{'v' => \23},
					       ]);
$result = q{$v: 23.  @v: [a b c].};
is ($text, $result, "Now we'll test the multiple-hash option (added for 1.20)");

exit;

