use strict;
use warnings;
use Test::More 
qw(no_plan);
# tests => 4;

use_ok('HTML::Template');
use lib("./t/testlib");
use_ok('HTML::Template27');

my (%templ, %templ27);
my ($x);

# test multiline tags
$templ{multiline} = HTML::Template->new(
    path        => ['templates'],
    filename    => 'multiline_tags.tmpl',
    global_vars => 1,
);

# test new() from filehandle
open(TEMPLATE, "templates/simple.tmpl");
$templ{new_fh} = HTML::Template->new(filehandle => *TEMPLATE);
close(TEMPLATE);

# test case sensitive loop variables
$templ{case_loop} = HTML::Template->new(
    path           => ['templates'],
    filename       => 'case_loop.tmpl',
    case_sensitive => 1,
);

## test ifs with code refd
$templ{if} = HTML::Template->new(
    path     => ['templates'],
    filename => 'if.tmpl',
);

# test global_vars for loops within loops
$templ{global_loops} = HTML::Template->new(
    path => ['templates'],
    filename => 'global-loops.tmpl',
    global_vars => 1,
);

# test nested include path handling
$templ{include_path_nested} = HTML::Template->new(
    path => ['templates'],
    filename => 'include_path/one.tmpl',
);

# test using HTML_TEMPLATE_ROOT with path
{
    local $ENV{HTML_TEMPLATE_ROOT} = "templates";
    $templ{env_root} = HTML::Template->new(
        path     => ['searchpath'],
        filename => 'three.tmpl',
    );
}

# test __counter__
$templ{counter} = HTML::Template->new(
    path              => ['templates'],
    filename          => 'counter.tmpl',
    loop_context_vars => 1,
);

# test default
$templ{default} = HTML::Template->new(
    path     => ['templates'],
    filename => 'default.tmpl',
);

# test javascript escaping
$templ{javascript} = HTML::Template->new(
    path     => ['templates'],
    filename => 'js.tmpl',
);

# test a case where a different path should stimulate a cache miss
# even though the main template is the same
$templ{search_path_on_include} = HTML::Template->new(
    path                   => ['templates', 'templates/include_path'],
    filename               => 'outer.tmpl',
    search_path_on_include => 1,
    cache                  => 1,
);

$templ{search_path_on_include2} = HTML::Template->new(
    path                   => ['templates', 'templates/include_path2'],
    filename               => 'outer.tmpl',
    search_path_on_include => 1,
    cache                  => 1,
);

foreach my $u (sort keys %templ) {
    isa_ok($templ{$u}, 'HTML::Template');
}


# test multiline tags
$templ27{multiline} = HTML::Template27->new(
    path        => ['templates'],
    filename    => 'multiline_tags.tmpl',
    global_vars => 1,
);

# test new() from filehandle
open(TEMPLATE, "templates/simple.tmpl");
$templ27{new_fh} = HTML::Template27->new(filehandle => *TEMPLATE);
close(TEMPLATE);

# test case sensitive loop variables
$templ27{case_loop} = HTML::Template27->new(
    path           => ['templates'],
    filename       => 'case_loop.tmpl',
    case_sensitive => 1,
);

## test ifs with code refd
$templ27{if} = HTML::Template27->new(
    path     => ['templates'],
    filename => 'if.tmpl',
);

# test global_vars for loops within loops
$templ27{global_loops} = HTML::Template27->new(
    path => ['templates'],
    filename => 'global-loops.tmpl',
    global_vars => 1,
);

# test nested include path handling
$templ27{include_path_nested} = HTML::Template27->new(
    path => ['templates'],
    filename => 'include_path/one.tmpl',
);

# test using HTML_TEMPLATE_ROOT with path
{
    local $ENV{HTML_TEMPLATE_ROOT} = "templates";
    $templ27{env_root} = HTML::Template27->new(
        path     => ['searchpath'],
        filename => 'three.tmpl',
    );
}

# test __counter__
$templ27{counter} = HTML::Template27->new(
    path              => ['templates'],
    filename          => 'counter.tmpl',
    loop_context_vars => 1,
);

# test default
$templ27{default} = HTML::Template27->new(
    path     => ['templates'],
    filename => 'default.tmpl',
);

# test javascript escaping
$templ27{javascript} = HTML::Template27->new(
    path     => ['templates'],
    filename => 'js.tmpl',
);

# test a case where a different path should stimulate a cache miss
# even though the main template is the same
$templ27{search_path_on_include} = HTML::Template27->new(
    path                   => ['templates', 'templates/include_path'],
    filename               => 'outer.tmpl',
    search_path_on_include => 1,
    cache                  => 1,
);

$templ27{search_path_on_include2} = HTML::Template27->new(
    path                   => ['templates', 'templates/include_path2'],
    filename               => 'outer.tmpl',
    search_path_on_include => 1,
    cache                  => 1,
);

foreach my $v (sort keys %templ27) {
    isa_ok($templ27{$v}, 'HTML::Template27');
}

foreach my $u (sort keys %templ) {
    is_deeply($templ{$u}, $templ27{$u}, "objects for $u have same structure");
}

=head1 NAME

t/706-cons.t 

=head1 OBJECTIVE

Sixth of 6 test files designed to guarantee that any changes made by
Phalanx (or subsequent maintainance) to C<HTML::Template::new()> return
an object with exactly the same structure as in HTML::Template v2.7.

See t/701-cons.t for further discussion.

=cut

