use strict;
use warnings;
use Test::More 
qw(no_plan);
# tests => 4;

use_ok('HTML::Template');
use lib("./t/testlib");
use_ok('HTML::Template27');

my (%templ, %templ27);

# test file cache - non automated, requires turning on debug watching STDERR!
$templ{temp_cache_dir} = HTML::Template->new(
    path => ['templates/'],
    filename => 'simple.tmpl',
    file_cache_dir => './blib/temp_cache_dir',
    file_cache => 1,
);

foreach my $u (sort keys %templ) {
    isa_ok($templ{$u}, 'HTML::Template');
}

$templ27{temp_cache_dir} = HTML::Template27->new(
    path => ['templates/'],
    filename => 'simple.tmpl',
    file_cache_dir => './blib/temp_cache_dir',
    file_cache => 1,
);

foreach my $v (sort keys %templ27) {
    isa_ok($templ27{$v}, 'HTML::Template27');
}

my $u = 'temp_cache_dir';
is_deeply($templ{$u}, $templ27{$u}, "objects for $u have same structure");

=head1 NAME

t/704-cons.t 

=head1 OBJECTIVE

Fourth of 6 test files designed to guarantee that any changes made by
Phalanx (or subsequent maintainance) to C<HTML::Template::new()> return
an object with exactly the same structure as in HTML::Template v2.7.

See t/701-cons.t for further discussion.

=cut

