use strict;
use warnings;
use Test::More 
qw(no_plan);
# tests => 4;

use_ok('HTML::Template');
use lib("./t/testlib");
use_ok('HTML::Template27');
# use Data::Dumper;

my (%templ, %templ27);

# test a template using unless
$templ{unless} = HTML::Template->new(
    path => 'templates',
    filename => 'unless.tmpl',
);

# test a template using loop_context_vars
$templ{context} = HTML::Template->new(
    path => 'templates',
    filename => 'context.tmpl',
    loop_context_vars => 1,
);

$templ{loop_if} = HTML::Template->new(
    path => 'templates',
    filename => 'loop-if.tmpl',
);

# test cache - non automated, requires turning on debug watching STDERR!
$templ{cache} = HTML::Template->new(
    path => ['templates/'],
    filename => 'simple.tmpl',
    cache => 1,
    debug => 0,
);

# test URL escapeing
$templ{urlescape} = HTML::Template->new(
    path => 'templates',
    filename => 'urlescape.tmpl',
);

# test query()
$templ{query} = HTML::Template->new(
    path => 'templates',
    filename => 'query-test.tmpl',
);

# test query()
$templ{query2} = HTML::Template->new(                                
    path => 'templates',
    filename => 'query-test2.tmpl',
);

# test global_vars
$templ{global} = HTML::Template->new(                                
    path => 'templates',
    filename => 'globals.tmpl',
    global_vars => 1,
);

$templ{vanguard} = HTML::Template->new(                                
    path => 'templates',
    filename => 'vanguard1.tmpl',
    vanguard_compatibility_mode => 1,
);

$templ{loop_context} = HTML::Template->new(                           
    path => 'templates',
    filename => 'loop-context.tmpl',
    loop_context_vars => 1,
);

# test a TMPL_INCLUDE from a later path directory back up to an earlier one
# when using the search_path_on_include option
$templ{searchpath} = HTML::Template->new(
    path => ['templates/searchpath/','templates/'],
    search_path_on_include => 1,
    filename => 'include.tmpl',
);

SKIP: {
    skip ("doesn't do the check yet", 0);
# test file cache - non automated, requires turning on debug watching STDERR!
$templ{temp_cache_dir} = HTML::Template->new(
    path => ['templates/'],
    filename => 'simple.tmpl',
    file_cache_dir => './blib/temp_cache_dir',
    file_cache => 1,
);
} # END SKIP BLOCK

foreach my $u (sort keys %templ) {
    isa_ok($templ{$u}, 'HTML::Template');
}

# test a template using unless
$templ27{unless} = HTML::Template27->new(
    path => 'templates',
    filename => 'unless.tmpl',
);

# test a template using loop_context_vars
$templ27{context} = HTML::Template27->new(
    path => 'templates',
    filename => 'context.tmpl',
    loop_context_vars => 1,
);

$templ27{loop_if} = HTML::Template27->new(
    path => 'templates',
    filename => 'loop-if.tmpl',
);

# test cache - non automated, requires turning on debug watching STDERR!
$templ27{cache} = HTML::Template27->new(
    path => ['templates/'],
    filename => 'simple.tmpl',
    cache => 1,
    debug => 0,
);

# test URL escapeing
$templ27{urlescape} = HTML::Template27->new(
    path => 'templates',
    filename => 'urlescape.tmpl',
);

# test query()
$templ27{query} = HTML::Template27->new(
    path => 'templates',
    filename => 'query-test.tmpl',
);

# test query()
$templ27{query2} = HTML::Template27->new(                                
    path => 'templates',
    filename => 'query-test2.tmpl',
);

# test global_vars
$templ27{global} = HTML::Template27->new(                                
    path => 'templates',
    filename => 'globals.tmpl',
    global_vars => 1,
);

$templ27{vanguard} = HTML::Template27->new(                                
    path => 'templates',
    filename => 'vanguard1.tmpl',
    vanguard_compatibility_mode => 1,
);

$templ27{loop_context} = HTML::Template27->new(                           
    path => 'templates',
    filename => 'loop-context.tmpl',
    loop_context_vars => 1,
);

# test a TMPL_INCLUDE from a later path directory back up to an earlier one
# when using the search_path_on_include option
$templ27{searchpath} = HTML::Template27->new(
    path => ['templates/searchpath/','templates/'],
    search_path_on_include => 1,
    filename => 'include.tmpl',
);

SKIP: {
    skip ("doesn't do the check yet", 0);
# test file cache - non automated, requires turning on debug watching STDERR!
$templ27{temp_cache_dir} = HTML::Template27->new(
    path => ['templates/'],
    filename => 'simple.tmpl',
    file_cache_dir => './blib/temp_cache_dir',
    file_cache => 1,
);
} # END SKIP BLOCK

foreach my $v (sort keys %templ27) {
    isa_ok($templ27{$v}, 'HTML::Template27');
}

foreach my $u (sort keys %templ) {
    is_deeply($templ{$u}, $templ27{$u}, "objects for $u have same structure");
}

=head1 NAME

t/703-cons.t 

=head1 OBJECTIVE

Third of 6 test files designed to guarantee that any changes made by
Phalanx (or subsequent maintainance) to C<HTML::Template::new()> return
an object with exactly the same structure as in HTML::Template v2.7.

See t/701-cons.t for further discussion.

=cut

